/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.dialog.comp.TimeParameterJPanel;
import DE.siemens.ad.logo.dialog.comp.TimeValueOrReferencePanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class HoursCounterTimebaseMinutePanel
extends AbstractProtectionPanel {
    private TimeValueOrReferencePanel fTimeInterval;
    TimeParameterJPanel fOperatingTimeStart;
    private JCheckBox fOutputBehavior;

    public HoursCounterTimebaseMinutePanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.initialize();
    }

    private void initialize() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.addParameterPane(panel);
        Timer fMI = ((HoursCounterParameter)this.fParameterReference).getMITimer();
        Timer fOTStart = ((HoursCounterParameter)this.fParameterReference).getOTStartTimer();
        this.fTimeInterval = this.createMITimePanel(fMI);
        this.fOperatingTimeStart = new TimeParameterJPanel(fOTStart);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        panel.add((Component)this.fTimeInterval, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 2, 5, 5);
        panel.add((Component)this.fOperatingTimeStart, gbc);
        this.fOutputBehavior = new JCheckBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        panel.add((Component)this.fOutputBehavior, gbc);
    }

    private TimeValueOrReferencePanel createMITimePanel(Timer timer) {
        TimeValueOrReferencePanel timePanel = new TimeValueOrReferencePanel(timer){

            protected TimeUnit[] getTimeUnitsForReference() {
                return new TimeUnit[]{new UnlimitedHours(9999)};
            }
        };
        Block block = ((BlockParameter)this.fParameterReference).getBlock();
        timePanel.setReferenceList(block.getWiringDiagram().getBlocksForReference(block, true));
        timePanel.setReferenceVisability(this.fParameterReference.isValueOrReference());
        timePanel.setLabels();
        return timePanel;
    }

    public boolean checkChanged() {
        HoursCounterParameter param = (HoursCounterParameter)this.fParameterReference;
        return super.checkChanged() || this.fTimeInterval.checkChanged() || this.fOperatingTimeStart.checkChanged() || this.fOutputBehavior.isSelected() != param.isOutputIndependentOfEn().booleanValue();
    }

    public boolean checkFieldContents() {
        return super.checkFieldContents() && this.fTimeInterval.checkFieldContents() && this.fOperatingTimeStart.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        this.fTimeInterval.loadFieldContents();
        this.fOperatingTimeStart.loadFieldContents();
        HoursCounterParameter param = (HoursCounterParameter)this.fParameterReference;
        this.fOutputBehavior.setSelected(param.isOutputIndependentOfEn());
        this.getRemanenceField().setEnabled(false);
    }

    public void setLabels() {
        super.setLabels();
        this.fOutputBehavior.setText(Language.getString("dialog.parameter.hoursCounter.outputBehavior", "Reset output on En==0"));
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        this.fTimeInterval.storeFieldContents();
        ((HoursCounterParameter)this.fParameterReference).updateMNAcordingToMI();
        this.fOperatingTimeStart.storeFieldContents();
        ((HoursCounterParameter)this.fParameterReference).setOutputIndependentOfEn(this.fOutputBehavior.isSelected());
    }
}

